#version 430 core

layout (location = 0) in vec3 fragNormal;
layout (location = 1) in vec2  fragTexCoords;
layout (location = 2) in vec4  fragPosLightSpace;
layout (location = 3) in vec4  fragViewPos;
layout (location = 4) in float  fragCrackDepth;
layout (location = 5) in vec3  fragNoiseCoords;
layout (location = 6) in float  fragResourceType;

layout (location = 0) out vec4 gAlbedoSpec;
layout (location = 1) out vec4 gViewPosition; //last one is also depth
layout (location = 2) out vec3 gNormal;
layout (location = 3) out vec4 gShadowVisibility;
layout (location = 4) out vec2 gInstanceID;
layout (location = 5) out vec4 gPhysical;

layout (binding = 1) uniform sampler2D rgbTexture;
layout (binding = 2) uniform sampler2D physicalTexture;

//crap for noise:

#define NUM_OCTAVES 5

const float PI = 3.1415926535897932384626433832795;

float hash(float n) { return fract(sin(n) * 1e4); }
float hash(vec2 p) { return fract(1e4 * sin(17.0 * p.x + p.y * 0.1) * (0.1 + abs(sin(p.y * 13.0 + p.x)))); }

float noise(vec3 x) {
	const vec3 step = vec3(110, 241, 171);

	vec3 i = floor(x);
	vec3 f = fract(x);
 
	// For performance, compute the base input to a 1D hash from the integer part of the argument and the 
	// incremental change to the 1D based on the 3D -> 1D wrapping
    float n = dot(i, step);

	vec3 u = f * f * (3.0 - 2.0 * f);
	return mix(mix(mix( hash(n + dot(step, vec3(0, 0, 0))), hash(n + dot(step, vec3(1, 0, 0))), u.x),
                   mix( hash(n + dot(step, vec3(0, 1, 0))), hash(n + dot(step, vec3(1, 1, 0))), u.x), u.y),
               mix(mix( hash(n + dot(step, vec3(0, 0, 1))), hash(n + dot(step, vec3(1, 0, 1))), u.x),
                   mix( hash(n + dot(step, vec3(0, 1, 1))), hash(n + dot(step, vec3(1, 1, 1))), u.x), u.y), u.z);
}

float fbm (vec3 _st) {
    float v = 0.0;
    float a = 0.5;
    vec3 shift = vec3(100.0f);
    // Rotate to reduce axial bias
    mat2 rot = mat2(cos(0.5), sin(0.5),
                    -sin(0.5), cos(0.50));
    for (int i = 0; i < NUM_OCTAVES; ++i) {
        v += a * noise(_st);
        _st = _st * 2.0 + shift;
        a *= 0.5;
    }
    return v;
}

//noise crap ends



uniform mat4 view;
uniform vec3 lightDir;

uniform int modelID;
uniform int planetType;

uniform float time;

//planet enums:

const int EARTH = 1;
const int STONE = 2;
const int SAND = 3;
const int MARS = 4;
const int ICE = 5;
const int VENUS = 6;
const int SEUSS = 7;
const int METAL = 8;
const int CLAY = 9;


float linearize_depth(float d,float zNear,float zFar)
{
  float z_n = 2.0 * d - 1.0;
  return 2.0 * zNear * zFar / (zFar + zNear - z_n * (zFar - zNear));
}

uniform vec3 primaryColor;
uniform vec3 secondaryColor;


void main(){
 
	gShadowVisibility.xyz = (fragPosLightSpace.xyz / fragPosLightSpace.w) * 0.5 + 0.5;

	vec4 color = vec4(texture(rgbTexture, fragTexCoords.xy));
	vec4 physical = vec4(texture(physicalTexture, fragTexCoords.xy));

	int resourceState = 0;

	float resourceBloomMagnitude = 0.15;

	if(fragResourceType > 0.0){

		color.xyz = mix(color.xyz, vec3(1.0, 1.0, 0.4), pow(abs(fragResourceType), 0.3));
		physical = mix(physical, vec4(0.2, 0, resourceBloomMagnitude, 0), pow(abs(fragResourceType), 0.3)) * 0.4;

		resourceState = 2;		

	}else if(fragResourceType < 0.0){

		color.xyz = mix(color.xyz, vec3(0.0, 1.0, 1.0), pow(abs(fragResourceType), 0.3));
		physical = mix(physical, vec4(0.2, 0, resourceBloomMagnitude, 0), pow(abs(fragResourceType), 0.3)) * 0.4;

		resourceState = 1;		
	}

	if(fragCrackDepth > 0.0){

		if(planetType == CLAY){
			
			float sootAmount = pow(fragCrackDepth, 0.33);

			color.xyz = mix(color.xyz, vec3(0.1), sootAmount);

			if(fragCrackDepth > 0.4){	

				//do lava here

				float noiseFreq = 45.0f;
				float firstNoise = fbm(fragNoiseCoords * noiseFreq);
				float finalNoise = abs(sin(time / 4.0 + firstNoise * 10.0f));

				vec3 lavaColor = vec3(1.0, 0.1, 0.0);

				vec3 secondaryColor = mix(lavaColor, vec3(0.0), 0.7);
				vec3 finalColor = mix(lavaColor, secondaryColor, finalNoise);

				color.xyz = finalColor;
				physical.z = 0.4;
			}

		}
		if(planetType == ICE){
			float metallicness = pow(fragCrackDepth, 0.33);

			vec3 HydroColor = vec3(0.0, 1.0, 1.0);

			vec4 hydroPhysical = vec4(0.0);

			float lightBrightness = abs(sin(time * PI / 2.0)) + 2.0;

			hydroPhysical.r = 0.2;
			hydroPhysical.z = lightBrightness / 4.0;

			color.xyz = mix(color.xyz, HydroColor, metallicness);
			physical = mix(physical, hydroPhysical, metallicness) * 0.4;

			if(metallicness > 0.1){
				resourceState = 1;
			}

		}
		if(planetType == VENUS){
			float metallicness = pow(fragCrackDepth, 0.33);

			vec3 siliconColor = vec3(1.0, 1.0, 0.4);

			vec4 siliconPhysical = vec4(0.2, 0, 1.5, 0);

			float lightBrightness = abs(sin(time * PI / 2.0)) + 2.0;

			siliconPhysical.z = lightBrightness / 4.0;

			color.xyz = mix(color.xyz, siliconColor, metallicness);
			physical = mix(physical, siliconPhysical, metallicness) * 0.4;

			if(metallicness > 0.1){
				resourceState = 2;
			}


		}
		if(planetType == SAND){
			float metallicness = pow(fragCrackDepth, 0.33);

			vec3 siliconColor = vec3(1.0, 1.0, 0.4);

			vec4 siliconPhysical = vec4(0.2, 0, 1.5, 0);

			float lightBrightness = abs(sin(time * PI / 2.0)) + 2.0;

			siliconPhysical.z = lightBrightness / 4.0;

			color.xyz = mix(color.xyz, siliconColor, metallicness);
			physical = mix(physical, siliconPhysical, metallicness) * 0.4;

			if(metallicness > 0.1){
				resourceState = 2;
			}


		}

		if(planetType == METAL){

			float metallicness = pow(fragCrackDepth, 0.33);

			color.xyz = mix(color.xyz, secondaryColor, metallicness);
			physical.x = mix(physical.x, 0.01, metallicness);

		}
		if(planetType == STONE){
			float sootAmount = pow(fragCrackDepth, 0.33);

			color.xyz = mix(color.xyz, vec3(0.1), sootAmount);

			if(fragCrackDepth > 0.4){	

				//do lava here

				float noiseFreq = 45.0f;
				float firstNoise = fbm(fragNoiseCoords * noiseFreq);
				float finalNoise = abs(sin(time / 4.0 + firstNoise * 10.0f));

				vec3 lavaColor = vec3(0.0, 1.0, 0.2);

				vec3 secondaryColor = mix(lavaColor, vec3(0.0), 0.7);
				vec3 finalColor = mix(lavaColor, secondaryColor, finalNoise);

				color.xyz = finalColor;
				physical.z = 0.4;
			}

		}
		
	}



	gAlbedoSpec.xyzw = color;
	gPhysical.xyzw = physical;


	gViewPosition.xyz = fragViewPos.xyz;

	gViewPosition.w = linearize_depth(gl_FragCoord.z, 1.0, 6000);

	gNormal = normalize(fragNormal.xyz);
	gInstanceID = vec2(modelID, resourceState);
	
}